##(nowrap)###################################################################
#############################################################################
#
# latex.tcl, version 4.9:  macros, menu, and key bindings for LaTeX users
#
#############################################################################
#
# version 1.1 and 1.2 (11/10/92) by Richard T. Austin <austin@eecs.umich.edu>
# versions 2.0--3.2 and 3.2t (3/97) by Tom Scavo <trscavo@syr.edu>
# versions 4.0 onwards (9/97) by Vince Darley <vince@santafe.edu>
# If you make improvements to this file, please share them!
#
# LaTeX 2.09 is no longer supported.  If someone wants to make the 
# necessary changes to support it, they are welcome.
#############################################################################
#############################################################################

# Initialize TeX mode:
alpha::mode TeX 4.9.6 loadLatexMode {
    *.tex *.ltx *.dtx *.ins *.cls *.clo *.sty *.log *.aux *.bbl *.idx 
    *.ind *.glo *.gls *.toc *.lof *.lot *.blg *.ilg *.fd *.drv *.fdd 
    *.def *.ini
} { 
    texMenu electricReturn electricTab
} { 
    addMenu texMenu "270" TeX
    set unixMode(latex) {TeX}
    
    alpha::package require AlphaTcl 7.4fc2
    # Reset the search path so it will be rebuilt the next time it's needed:
    set AllTeXSearchPaths {}
    
    # Initialize TeX-related application signatures:
    newPref sig texSig ""
    newPref sig viewDVISig ""
    newPref sig printDVISig ""
    newPref sig dvipsSig ""
    newPref sig dvipdfSig ""
    newPref sig distillPSSig ""
    newPref sig pdflatexSig ""
    newPref sig printPSSig ""
    newPref sig bibtexSig ""
    newPref sig makeindexSig ""
    
    # Install the short LaTeX menu, by default:
    ensureset useShortLaTeXMenu 1
    
    # Do not load AMS-LaTeX, by default:
    ensureset useAMSLaTeX 0
    
    # To add a new fileset type, all we have to do is this:
    fileset::registerNewType tex tex
    # when a tex-fileset changes, call this proc
    hook::register fileset-update makeProcessMenu "tex" 
    # Add more options to the 'New Document' prompt
    set {newDocTypes(New LaTeX Doc)} newLaTeXDocument

    # Placed these here so BibTeX mode can definitely access them.
    set texParaCommands {\[|\]|begin|end|(protect\\)?label|(sub)*section\*?|subfigure|paragraph|centerline|centering|caption|chapter|item|bibitem|intertext|(protect\\)?newline|includegraphics\*?}
    namespace eval TeX {}
    set TeX::startPara {^[ \t]*$|\\\\[ \t]*$|(^|[^\\])%|\\h+line[ \t]*$|\$\$[ \t]*$|^[ \t]*(\\(}
    append TeX::startPara $texParaCommands {)(\[.*\]|\{.*\}|)*[ \t]*)+$}
    set TeX::endPara {^[ \t]*$|(^|[^\\])%|\$\$[ \t]*$|^[ \t]*(\\(}
    append TeX::endPara $texParaCommands {)(\[.*\]|\{.*\}|)*[ \t]*)+$}
} maintainer {
    "Frdric Boulanger" 
} uninstall {this-directory} help {file "LaTeX Help"}

#############################################################################
#
# Autoload procedures
#
#############################################################################

proc dummyTeX {} {}
proc texMenu {} {
    loadLatexMode
}

# Update some old preferences:
if {[info exists TeXmodeVars(TeXInputsFolder)]} {
    alertnote "The 'TeXInputsFolder' pref has been replaced by\
      'TeXSearchPath', which is now a list of folders to search.\
      I'll copy over your preference and delete the old one."
    # Can't use prefs::renameOld because we are turning a single
    # folder into a search path.
    lappend TeXmodeVars(TeXSearchPath) $TeXmodeVars(TeXInputsFolder)
    unset TeXmodeVars(TeXInputsFolder)
    lappend modifiedArrayElements [list TeXInputsFolder TeXmodeVars] \
      [list TeXSearchPath TeXmodeVars]
}

prefs::renameOld TeXmodeVars(dontIndentBeginEnd) TeXmodeVars(dontIndentLaTeXenvironments)

#############################################################################
#
# Flags and variables
#
#############################################################################

# Flags ---

# Files with these suffixes are considered TeXable.
newPref variable texableFileExtensions\
   [list .tex .dtx .ins .ltx .drv .fdd .err .mtx .etx .texi] TeX
# If a particular template requires a certain package, warn if it's not there.
newPref f warnIfPackageNotIncluded 1 TeX
# Build the submenu of all known packages.  Can be slow.
newPref f buildPkgsSubmenu 0 TeX
newPref f deleteEnvNoisily 1 TeX
newPref f deleteObjNoisily 1 TeX
# Typeset occurs in background by default (you can always override with
# a different key-combination
newPref f runTeXInBack 0 TeX makeProcessMenu
# When your actions require the mode to search for something, 'beep'
# if the search fails (otherwise just post a silent message).
newPref f searchNoisily 1 TeX
# Turn '...' into '\ldots' automatically as you type
newPref f smartDots 1 TeX
# Turn ' or " into ` or `` or ' or '' automatically as you type, depending
# upon the context
newPref f smartQuotes 1 TeX
newPref f useBrackets 0 TeX
# Use '$...$' and '$$...$$' for mathematics rather than the LaTeX
# expressions
newPref f useDollarSigns 0 TeX shadowUseDollarSigns
newPref f wordWrap 1 TeX

# names of commands which insert boxed graphics
newPref v boxMacroNames {includegraphics includegraphics*} TeX shadowBoxMacroNames
# commands used by your citation package
newPref v citeCommands {cite nocite citet citeauthor citep citeyear} TeX shadowCiteRefCommands
# the list of known mathematical environments
newPref v mathEnvironments [list "math" "displaymath" "equation" "eqnarray" "eqnarray*" "array"] TeX
newPref v fillColumn {70} TeX
newPref v funcExpr {\\(sub)*section(\[.*\]|\*)?({[^{}]*})?} TeX
newPref v parseExpr {[^\{]*\{([^\}]*)\}[^\}]*} TeX
newPref v funcExprAlt {\\section(\[.*\]|\*)?({[^{}]*})?} TeX 
newPref v leftFillColumn {0} TeX
newPref v prefixString {% } TeX
# the commands which are used to refer to labels elsewhere in the text
newPref v refCommands {ref eqref pageref vref vpageref} TeX shadowCiteRefCommands
newPref v wrapBreak {(\w+|\\(\\\*?|[^A-Za-z\t\r*\s\]|[A-Za-z]+\*?))} TeX
if {[info tclversion] < 8.0} {
    newPref v wrapBreakPreface {([^\w\]|.\\)} TeX
} else {
    newPref v wrapBreakPreface {([^\w\\\]|.\\)} TeX
}
newPref v wordBreak {(([-\w:0-9])+|\\(\\|[a-zA-Z]+)\*?|\\[^a-zA-Z*\s])} TeX
if {[info tclversion] < 8.0} {
    newPref v wordBreakPreface "(\[^-\\w:\\\]|.\\\\)" TeX
} else {
    newPref v wordBreakPreface "(\[^-\\w:\\\\\]|.\\\\)" TeX
}

# Where your TeX application searches for input files
newPref v TeXSearchPath "" TeX shadowTeXInputs
# The delimiter to use by default in labels inserted into the text.
# For instance the default is a colon, so labels are written 
# \label{fig:...} or \label{eq:...}.  You may prefer a hyphen '-' or...
newPref v standardTeXLabelDelimiter ":" TeX \
  {hook::callAll TeX::labelDelimChanged *}

# how to handle comments continuation
newPref v commentsContinuation 2 TeX "" \
  [list "only at line start" "spaces allowed" "anywhere"] index

# Pressing this key will insert a subscript _{} if the context is relevant
newPref binding smartSubscripts "/_<U" TeX "" 1
# Pressing this key will insert a superscript _{} if the context is relevant
newPref binding smartSuperscripts "/^<U" TeX "" 1
# If possible, show TeX log inside Alpha (doesn't work with all TeX apps)
newPref variable showTeXLog 1 TeX "" \
  [list "Never" "Only after error" "Always"] index
# Chooses between using the Marks menu for a list of TeX commands or
# the structural content of the file.
newPref variable markCommandsNotStructure \
  [list .sty .dtx .cls .clo .def .cfg .fd] TeX
# Don't indent lines between \begin,\end pairs. This only works for
# automatic indentation after you press return or tab, not for blocks
# of code inserted on the fly by code templates for example.
newPref flag dontIndentLaTeXenvironments 0 TeX
# Take over entire numeric keypad with dummy bindings.  Helps to avoid
# bad keypresses
newPref flag takeOverNumericKeypad 1 TeX
# If you are using the latest (beta) Textures, turn this on.
newPref flag useNewerTexturesInterface 0 TeX
# Textures flash mode
newPref flag useTexturesFlashMode 1 TeX shadowtexSig
# Control-Command double-clicking on a LaTeX keyword will send it to this
# url for a help reference page.
newPref url latexHelp {http://www.emerson.emory.edu/services/latex/latex2e/search=context?query=} TeX

# If you use CMacTeX >= 4.0, turn this on
newPref flag useNewerCMacTeXInterface 0 TeX TeX::switchCMacTeXInterface

# If you don't want the format name to be inserted on the first line of
# your TeX files (in the form %&latex for instance), turn this on.
newPref flag noFormatNameInFile 0 TeX TeX::switchFmtNameInFile

# Set AppSigs and AppScript according to choosen CMacTeX interface
TeX::switchCMacTeXInterface "useNewerCMacTeXInterface"

# List of available TeX formats. There is not need to list all variants of
# the TeX and LaTeX formats for different TeX programs if
# noFormatNameInFile is set since the name of the format will be adjusted
# for the choosen program (latex will become pdflatex for pdftex and
# pdfelatex for pdfetex).
# If noFormatNameInFile is not set, you need the full list of all formats
# for all TeX programs.
# Format names are transformed when switching noFormatNameInFile
newPref variable availableTeXFormats [list \
 "TeX" \
 "LaTeX" \
 "eTeX" \
 "eLaTeX" \
 "PDFTeX" \
 "PDFLaTeX" \
 "PDFeTeX" \
 "PDFeLaTeX" \
] TeX TeX::updateFormatList

# Name of the TeX format to use
newPref variable nameOfTeXFormat "LaTeX" TeX

# If checked, the format names do not depend on the
# name of the TeX program (the latex format has the same name for tex, 
# etex or pdftex).
newPref flag fixedFormatNames 1 TeX

# List of available TeX programs
newPref variable availableTeXPrograms [list \
 "tex" \
 "etex" \
 "pdftex" \
 "pdfetex" \
] TeX TeX::updateProgramList

# Name of the current TeX program to use (defaults to "tex")
newPref variable nameOfTeXProgram "tex" TeX

# Extensions of auxiliary files.
newPref variable auxFileExtensions [list \
 ".ps" \
 ".dvi" \
 ".log" \
 ".aux" \
 ".bbl" \
 ".idx" \
 ".ind" \
 ".glo" \
 ".gls" \
 ".toc" \
 ".lof" \
 ".lot" \
 ".blg" \
 ".ilg" \
] TeX

# ist file to use when building index
ensureset TeX::indexStyle

# ist file to use when building glossary
ensureset TeX::glossaryStyle

# BibTeX options (CMacTeX)
newPref variable bibtexOptions "" TeX

# dvips options (CMacTeX)
newPref variable dvipsOptions "" TeX

# Set menus from preferences
TeX::updateProgramList "availableTeXPrograms"
TeX::updateFormatList "availableTeXFormats"
#
############

# Could add '--src' here for embedding of src information in dvi
# files (e.g. for use with MikTeX).
newPref variable additionalTeXFlags "" TeX

# TeX mode initialisations:
set TeX::escapeChar "\\"

set TeX::commentCharacters(General)     "%"
set TeX::commentCharacters(Paragraph)   [list "%% " " %%" " % "]
set TeX::commentCharacters(Box)         [list "%" 1 "%" 1 "%" 3]

#############################################################################
#
# Initialization
#
#############################################################################

hook::register activateHook TeX::activate TeX
hook::register saveasHook makeProcessMenu TeX

proc makeProcessMenu {args} {
    if {[package::active texMenu]} {
	menu::buildSome Process
    }
}

proc TeX::activate {name} {
    global TeX::tmpFile PREFS
    if {[info exists TeX::tmpFile($name)]} {
	if {[file::pathStartsWith $name [file join ${PREFS} tmp]]} {
	    # It was a temporary file
	    message "$name is temporary"
	    # Send a message to myself, to arrive after the window
	    # has been completely opened (else killWindow will crash Alpha).
	    dosc -c 'ALFA' [list TeX::fromTempToReal $name]
	}
    } else {
	makeProcessMenu
    }
}

proc TeX::fromTempToReal {name} {
    global TeX::tmpFile
    # Bring temp window to front, find cursor position and close the window.
    bringToFront $name
    set tempRowCol [posToRowCol [set tempPos [getPos]]]
    killWindow
    # Now get the real window, and go to the correct position.
    if {[info exists TeX::tmpFile($name)]} {
	set item [set TeX::tmpFile($name)]
	unset TeX::tmpFile($name)
	switch -- [lindex $item 0] {
	    "clipboard" {
		alertnote "There is no original file to edit; you were\
		  typesetting the clipboard."
		return
	    }
	    "selection" {
		set file [lindex $item 1]
		set lineOffset [lindex $item 2]
		bringToFront $file
		goto [rowColToPos [expr {$lineOffset + [lindex $tempRowCol 0]}] [lindex $tempRowCol 1]]
		message "Editing on given TeX line"
		return
	    }
	}
    }
    alertnote "Couldn't find original file!"
}

# registered only if we're using Textures
# gets a jobid
proc TexturesopenHook {name} {
    if {[regexp "\\* TeX Electrics Tutorial \\*( <\[0-9\]+>)*" $name]} {
	return
    }
    global Texturesconnections
    set TeXjob ""
    if {[info exists Texturesconnections]} {
	foreach entry $Texturesconnections {
	    if {[lindex $entry 0] == $name} {
		set TeXjob [lindex $entry 1]
		break
	    }
	}
    }
    if { $TeXjob == "" } {
	global texAppSignatures
	if {![file exists $name]} {
	    switch [askyesno -c "Save current file?"] {
		"yes" {
		    saveAs
		    set name [win::Current]
		}
		"no" -
		"cancel" {return}
	    }
	}
	if {![catch {set TeXjob [AEBuild -r '$texAppSignatures(Textures)' \
				 BSRs Begi "----" [tclAE::build::alis $name]]}]} {
	    set TeXjob [string trim [string range $TeXjob 15 end] {\{\}\"}]
	    lappend Texturesconnections [list $name $TeXjob]
	}
    }
}

proc TexturescloseHook {name} {
    global Texturesconnections
    if {[info exists Texturesconnections]} {
	set winNames {}
	foreach tc $Texturesconnections {
	    lappend winNames [lindex $tc 0]
	}
	if { [set pos [lsearch -exact $winNames $name]] > -1 } {
	    # Close Textures' connection:
	    global texAppSignatures
	    set TeXjob [lindex [lindex $Texturesconnections $pos] 1]
	    AEBuild -r '$texAppSignatures(Textures)' BSRs Disc Jobi $TeXjob
	    # Update list of connections:
	    set Texturesconnections [lreplace $Texturesconnections $pos $pos]
	}
    }
}

proc TexturessaveasHook {oldName newName} {
    TexturescloseHook $oldName
    TexturesopenHook $newName
}

proc TexturesLaunched {args} {
    global Texturesconnections menu::items
    set Texturesconnections ""
    
    
    set mnu [AEBuild -r '*TEX' BSRs Info Fmts long(0)]
    set mnu [string range $mnu 15 999]
    set mnu [string trim $mnu "{}"]
    set "menu::items(Format)" $mnu
}

proc doFlash {args} {
    global TeXmodeVars
    if {$TeXmodeVars(useTexturesFlashMode)} {
	typeset 1
    }
}

# called by command-click on Textures dvi window to move Alpha selection point
# eventHandler BSRs SelP setSelect
proc setSelect {str} {
    global texAppSignatures Texturesconnections

    # find window for the jobid
    set TeXwin 0
    regexp {Jobi:([0-9]+),} $str "" TeXjob
    if {[info exists Texturesconnections]} {
	foreach entry $Texturesconnections {
	    if {[lindex $entry 1] == $TeXjob} {
		set TeXwin [lindex $entry 0]
		break
	    }
	}
    }

    if {$TeXwin==0} {
	set TeXwin [aeparse::keywordValue "alis" [aeparse::event $str]]
	openTeXFile $TeXwin ".tex"
    }

    regexp {'----'\:([0-9]+),} $str dum selpt
    switchTo 'ALFA'
    bringToFront [file tail $TeXwin]
    select -w $TeXwin $selpt [pos::math $selpt + 1]
    unset selpt
}

# eventHandler BSRs GetT getBSRText
proc getBSRText {str} {
    global texAppSignatures Texturesconnections

    # find window for the jobid
    regexp {Jobi:([0-9]+),} $str "" TeXjob
    if {[info exists Texturesconnections]} {
	foreach entry $Texturesconnections {
	    if {[lindex $entry 1] == $TeXjob} {
		set TeXwin [lindex $entry 0]
		break
	    }
	}
    }
    set str \[getText -w $TeXwin [minPos] [maxPos -w $TeXwin]]\
    AEBuild -t 1200 -r '$texAppSignatures(Textures)' BSRs TTeX TEXT $str Jobi $TeXjob 
}

# The proc 'shadowtexSig' is executed automatically whenever 
# the global variable 'texSig' is altered, say, by choosing
# 'removedSavedSetting' on the Config menu.  Alpha now has
# a nifty proc to handle all the hard work for us: (Vince)
proc shadowtexSig {args} {
    global packagesSubmenuItems AllTeXSearchPaths texSig texAppSignatures \
      TeXmodeVars
    # Reset the Packages submenu so that it will be rebuilt:
    set packagesSubmenuItems ""
    # Set things up for Textures
    global menu::items
    if {[info exists texAppSignatures(Textures)] && \
      $texSig == $texAppSignatures(Textures)} {

        hook::register launch TexturesLaunched $texAppSignatures(Textures)
        hook::register closeHook TexturescloseHook TeX
        hook::register controlClickHook synchronizeDoc TeX
	hook::register saveasHook TexturessaveasHook TeX
	hook::register openHook TexturesopenHook TeX
	if {$TeXmodeVars(useNewerTexturesInterface)} {
	    hook::register changeTextHook doFlash TeX 
	    eventHandler BSRs SelP setSelect
	    eventHandler BSRs GetT getBSRText
	    # In case it isn't running!
	    catch {
		set mnu [AEBuild -r '*TEX' BSRs Info Fmts long(0)]
		set mnu [string range $mnu 15 999]
		set mnu [string trim $mnu "{}"]
		set "menu::items(Format)" $mnu
	    }
	    if {[info tclversion] < 8.0} {
		Bind '\ ' {typeText " " ; doFlash} TeX
	    }
	}
    } else {
        hook::deregister launch TexturesLaunched $texAppSignatures(Textures)
        hook::deregister closeHook TexturescloseHook TeX
	hook::deregister saveasHook TexturessaveasHook TeX
        hook::deregister controlClickHook synchronizeDoc TeX
	hook::deregister openHook TexturesopenHook TeX
	if {$TeXmodeVars(useNewerTexturesInterface)} {
	    hook::deregister changeTextHook doFlash TeX 
	    set "menu::items(Format)" [list "LaTeX" \
	      "Big-LaTeX" "AMS-TeX" "Plain TeX"]
	    if {[info tclversion] < 8.0} {
		unBind '\ ' {typeText " " ; doFlash} TeX
	    }
	}
    }
    message {Building LaTeX menu}
    buildLaTeXMenuQuietly
    # Reset the search path so it will be rebuilt the next time it's needed:
    set AllTeXSearchPaths {}
    
}

proc shadowTeXInputs {args} {
    global packagesSubmenuItems AllTeXSearchPaths
    
    # Reset the Packages submenu so that it will be rebuilt:
    set packagesSubmenuItems ""
    
    message "Rebuilding the Documents submenu"
    menu::buildSome Documents
    message ""
    
    # Reset the search path so it will be rebuilt the next time it's needed:
    set AllTeXSearchPaths {}
}

# The proc 'shadowUseDollarSigns' is executed automatically whenever 
# the flag 'useDollarSigns' is altered.  
proc shadowUseDollarSigns {args} {
    TeX::sub::MathModes
    menu::buildSome "Math Modes"
}

# we indent to previous non-comment line, +- a bit for \begin or \end
proc TeX::indentLine {} {
    set beg [lineStart [set p [getPos]]]
    set text [getText $beg [nextLineStart $beg]]
    regexp "^\[ \t\]*" $text white
    set next [pos::math $beg + [string length $white]]
    set end [pos::math $next + 5]
    if {[pos::compare $end > [maxPos]]} {set end [maxPos]}
    set lwhite [TeX::correctIndentation [getPos] [getText $next $end]]
    
    set lwhite [text::indentOf $lwhite]
    if {$white != $lwhite} {
	replaceText $beg $next $lwhite
    }
    goto [pos::math $beg + [string length $lwhite]]
    # To keep relative position.
    #goto [pos::math $p + [string length $lwhite] - [pos::diff $beg $next]]
}

proc TeX::correctIndentation {pos {next ""}} {
    global indentationAmount commentsArentSpecialWhenIndenting dontIndentLaTeXenvironments
    set beg [lineStart $pos]

    # find last non-empty, non-comment line
    if {$commentsArentSpecialWhenIndenting} {
	if {[catch {search -s -f 0 -r 1 -i 0 -m 0 -- "^\[ \t\]*\[^ \t\n\r\]" [pos::math $beg - 1]} lst]} {
	    return 0
	}
    } else {
	if {[catch {search -s -f 0 -r 1 -i 0 -m 0 -- "^\[ \t\]*\[^ \t\n\r%\]" [pos::math $beg - 1]} lst]} {
	    return 0
	}
    }
    
    set line [getText [lindex $lst 0] [pos::math [nextLineStart [lindex $lst 0]] - 1]]
    set lwhite [posX [pos::math [lindex $lst 1] - 1]]	
    if {!$dontIndentLaTeXenvironments} {
	incr lwhite [expr {$indentationAmount * \
	  ([regexp {^[ \t]*\\begin\{} $line] - [regexp {^\\end\{} $next])}]
    }
    # only happens with poorly formatted files.
    if {$lwhite < 0} {return 0} else {return $lwhite}
}

#############################################################################
#
# Colorization
#
#############################################################################

newPref color keywordColor blue TeX
newPref color sectionColor magenta TeX
newPref color commentColor red TeX
newPref color bracesColor green TeX

# The proc 'shadowCiteRefCommands' is executed whenever the variables 
# TeXmodeVars(citeCommands) or TeXmodeVars(refCommands) are changed.
proc shadowCiteRefCommands {args} {
    global TeXmodeVars
    set LaTeXClickWords {}
    # insure that 'citeCommands' contains "cite" and "nocite":
    lunion TeXmodeVars(citeCommands) cite nocite
    foreach word $TeXmodeVars(citeCommands) { 
	lappend LaTeXClickWords "\\\\$word" 
    }
    # insure that 'refCommands' contains "ref" and "pageref":
    lunion TeXmodeVars(refCommands) ref pageref
    foreach word $TeXmodeVars(refCommands) { 
	lappend LaTeXClickWords "\\\\$word" 
    }
    # color and underline command-double-clickable LaTeX commands:
    regModeKeywords -a -u -k $TeXmodeVars(keywordColor) TeX $LaTeXClickWords
}

# The proc 'shadowBoxMacroNames' is executed whenever the variable 
# TeXmodeVars(boxMacroNames) is changed.
proc shadowBoxMacroNames {args} {
    global TeXmodeVars
    set LaTeXClickWords {}
    foreach word $TeXmodeVars(boxMacroNames) { 
	lappend LaTeXClickWords "\\\\$word" 
    }
    # color and underline command-double-clickable LaTeX commands:
    regModeKeywords -a -u -k $TeXmodeVars(keywordColor) TeX $LaTeXClickWords
}

proc colorLaTeXClickCommands {} {
    global TeXmodeVars
    lappend LaTeXClickWords \\documentclass \\usepackage \
      \\input \\include \\InputIfFileExists \
      \\bibliography \\bibliographystyle \
      \\LoadClass \\RequirePackage
    # color and underline command-double-clickable LaTeX commands:
    regModeKeywords -a -u -k $TeXmodeVars(keywordColor) TeX $LaTeXClickWords
    shadowCiteRefCommands
    shadowBoxMacroNames
}

proc colorLaTeXCommands {} {
    global TeXmodeVars 
    set LaTeXKeyWords {}
    # Color comments, braces and dollar signs, and all LaTeX commands:
    regModeKeywords -i "\}" -i "\{" -i "\$" -I $TeXmodeVars(bracesColor) \
      -e {%} -m "\\" -c $TeXmodeVars(commentColor) \
      -k $TeXmodeVars(keywordColor) TeX $LaTeXKeyWords
    # Color sectioning commands:
    regModeKeywords -a -k $TeXmodeVars(sectionColor) TeX \
      { \\part \\chapter \\section \\subsection \\subsubsection \\paragraph }
}

colorLaTeXCommands; rename colorLaTeXCommands ""
colorLaTeXClickCommands; rename colorLaTeXClickCommands ""

#############################################################################
#
# LaTeX initialisation
#
#############################################################################

proc loadLatexMode {} {
    if {[alpha::tryToLoad "Initialising LaTeX menu and keys" \
      bindLaTeXKeys {Binding LaTeX keys} \
      [list app::registerMultiple tex [list OTEX *TEX *XeT pXeT pxeT MPS*] \
      [list 266 267 272 272 272 299] shadowtexSig] {Building LaTeX menu}]} {
	rename bindLaTeXKeys ""
	rename loadLatexMode ""
	proc loadLatexMode {} {}
    }
}

if {[alpha::tryToLoad "Initialising LaTeX" \
  latexEngine.tcl {} \
  latexComm.tcl {}\
  latexMacros.tcl {}\
  latexMenu.tcl {} \
  latexKeys.tcl {}]} {
    # nothing
}




